/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* -----------------------------------------------------------------------
 * File: buildin.h
 * Author: Bernhard Holzinger 12.09.96
 * Purpose: This file contains the function prototypes for the buildin
 * test function.
 * ----------------------------------------------------------------------- */

#ifndef BUILDIN_H_INCLUDED
#define BUILDIN_H_INCLUDED

#include <propdefs.h>


#define READ_PAGE  0x0
#define WRITE_PAGE 0x1


/* test setup commands */
#define B_TSTSETUP_WRITEATTR 0
#define B_TSTSETUP_INIT 1

/* test messages */
#define B_TSTMSG_RUN_ERROR   1
#define B_TSTMSG_RUNNING     2

/* timer cmds */
#define B_TSTTIMER_STOP         0
#define B_TSTTIMER_RUN          1
#define B_TSTTIMER_CLEAR_ACTUAL 2
#define B_TSTTIMER_CLEAR_TERR   3
#define B_TSTTIMER_CLEAR_PERR   4
#define B_TSTTIMER_CLEAR_TRACE  5

#ifdef __cplusplus
extern "C" {
#endif


CLI b_errtype EXPORT BestTestProtErrDetect(                       /* @testpedet */
					   b_handletype handle
					   );


CLI b_errtype EXPORT BestTestResultDump(                          /* @testrdump */
					b_handletype  handle,
					b_charptrtype filename    /* @file */
					);


CLI b_errtype EXPORT BestTestPropSet(                             /* @testprpset */
				     b_handletype   handle,
				     b_testproptype testprop,     /* @prop */  
				     b_int32        value         /* @val */
				     );


CLI b_errtype EXPORT BestTestPropDefaultSet(                      /* @testprpdefset */
					    b_handletype handle
					    );


CLI b_errtype EXPORT BestTestRun(                                 /* @testrun */
				 b_handletype handle,
				 b_int32      testcmd             /* @cmd */
				 );

CLI b_errtype EXPORT BestTestTimerRun(				  /* @testtimrun */
				b_handletype handle
				);

CLI b_errtype EXPORT BestTestTimerStop(				  /* @testtimstop */
				b_handletype handle
				);

CLI b_errtype EXPORT BestTestTimerValueGet(			  /* @testtimvget */
				b_handletype handle,
				b_timertype timer,		 /* @timer */
				b_int32 *value			 /* #RETURN "value =: %08lx\\h" */
				);

CLI b_errtype EXPORT BestTestTimerRegClear(			  /* @testtimrclear */
				b_handletype handle,
				b_timertype timer		 /* @timer */
				);

CLI b_errtype EXPORT BestTestBufferDump(			/* @testbufdump */
				b_handletype handle,
				b_int32 *num_of_bytes,		/* #RETURN "length =: %08lx\\h\n" */
				b_int8 HUGE *data_ptr		/* #RETURN intelhexdump(data_ptr,num_of_bytes,cmd,NULL,NULL) [num_of_bytes] */
				);

CLI b_errtype EXPORT BestTestBufferFill(			/* @testbuffill */
				b_handletype handle,
				b_int32 num_of_bytes,		/* @nob */
				b_int8 HUGE *data_ptr		/* @data */
				);

#ifdef __cplusplus
}
#endif

#endif
